<?xml version="1.0" encoding="UTF-8"?>
<template expand_clusters="true" version="2">
    <!-- Basic system utilization stuff -->
    <chart title="CPU Activity" series_composition="stacked" rendering_type="bar" average_selection="yes" average_cores="yes" percentage="yes">
        <series name="User" expression="$CPUActivityUser" description="Linux User activity" display="AVERAGE" color="58,223,67"/>
        <series name="System" expression="$CPUActivitySystem" description="Linux System activity" display="AVERAGE" color="223,71,66"/>
    </chart>
    <chart title="Cycles" series_composition="overlay" rendering_type="line">
        <series name="CPU Cycles" expression="$CyclesCPUCycles" description="The counter increments on every cycle" display="ACCUMULATE" color="94,142,235" units="cycles"/>
        <series name="SME Cycles" expression="$CyclesSMECycles" description="Counts SME clock cycles (not timer cycles). The clock measured by this event is defined as the physical clock driving the SME logic." display="ACCUMULATE" color="87,227,137" units="cycles"/>
    </chart>

    <!-- Basic IPC stuff -->
    <chart title="IPC" series_composition="overlay" rendering_type="line" optional="yes">
        <series name="CPU IPC" expression="$InstructionsExecutedAll/$CyclesCPUCycles" description="" display="ACCUMULATE" color="53,132,228"/>
        <series name="SME IPC" expression="$InstructionsExecutedSME/$CyclesSMECycles" description="" display="ACCUMULATE" color="51,209,122"/>
    </chart>
    <chart title="SME/CPU Insn Ratio" series_composition="stacked" rendering_type="bar" optional="yes">
        <series name="CPU" expression="$InstructionsExecutedAll" description="" display="ACCUMULATE" color="53,132,228" units="insns"/>
        <series name="SME" expression="$InstructionsExecutedSME" description="" display="ACCUMULATE" color="51,209,122" units="insns"/>
    </chart>

    <!-- Stalls -->
    <chart title="CPU / SME Memory Hazards" series_composition="stacked" rendering_type="bar" percentage="yes">
        <series name="CPU stalled by SME" expression="min($StallsBackendCPUStalledBySMEMemoryHazard/$CyclesCPUCycles, 1)" description="Percentage of cycles where the CPU was stalled because at least one CPU load/store instruction is waiting for resolution from an address hazard, and the CPU cannot execute the operation to preserve required ordering of memory effects. Typically indicates that the CPU and SME are making overlapping accesses, that is, both are accessing the same location" display="ACCUMULATE" color="255,163,72" units="%"/>
        <series name="SME Stalled by CPU" expression="min($StallsBackendSMEStalledByCPUMemoryHazard/$CyclesCPUCycles, 1)" description="Percentage of cycles where the CPU was stalled because at least one Streaming SVE load/store instruction is waiting for resolution from an address hazard, and the SME cannot accept the operation to preserve required ordering of memory effects. Typically indicates that the CPU and SME are making overlapping accesses, that is, both are accessing the same location" display="ACCUMULATE" color="224,27,36" units="%"/>
    </chart>
    <chart title="SME Backend Stall Cycles" series_composition="stacked" rendering_type="bar" percentage="yes">
        <series name="Loads" expression="min($StallsSMEBackendMemoryWaitingOnCache/$CyclesSMECycles,1)" description="Percentage of SME cycles where the SME unit is stalled in the backend due to an outstanding load that is waiting for cache arbitration" display="ACCUMULATE" color="220,138,221" units="cycles"/>
        <series name="Prefetcher" expression="min($StallsSMEBackendPrefetcher/$CyclesSMECycles,1)" description="Percentage of SME cycles where the SME unit is stalled in the backend due to prefetcher issue queues not accepting instructions" display="ACCUMULATE" color="249,240,107" units="%"/>
    </chart>

    <!-- Cache Effectiveness -->
    <chart title="SME Cache Accesses" series_composition="overlay" rendering_type="line" description="Shows the average number of accesses per cycle for each level of the SME memory hierarchy">
        <series name="L1D" expression="$L1DataCacheAccessSME/$CyclesSMECycles" description="The average number of accesses to the L1 Data Cache due to SME per SME cycle" display="ACCUMULATE" color="120,210,136"/>
        <series name="L3D" expression="$L3DataCacheAccessSME/$CyclesSMECycles" description="The average number of accesses to the L3 Data Cache due to SME per SME cycle" display="ACCUMULATE" color="246,211,45"/>
        <series name="LLC" expression="$LastLevelCacheAccessSMEDueToRead/$CyclesSMECycles" description="The average number of accesses to the Last-Level Data Cache due to SME per SME cycle" display="ACCUMULATE" color="255,120,0"/>
        <series name="DRAM" expression="$MemoryAccessToDRAMSME/$CyclesSMECycles" description="The average number of accesses to DRAM due to SME per SME cycle" display="ACCUMULATE" color="224,27,36"/>
    </chart>
    <chart title="SME Cache MPKI" series_composition="stacked" rendering_type="bar">
        <series name="L1D" expression="($L1DataCacheRefillSME / $InstructionsExecutedSME) * 1000" description="The number of L1 Data Cache misses per 1000 SME operations" display="ACCUMULATE" color="224,27,36" units="misses"/>
        <series name="L3D" expression="($L3DataCacheRefillSME / $InstructionsExecutedSME) * 1000" description="The number of L3 Data Cache misses per 1000 SME operations" display="ACCUMULATE" color="255,120,0" units="misses"/>
        <series name="LLC" expression="(($LastLevelCacheAccessSMEDueToRead - $LastLevelCacheMissSMEDueToRead) / $InstructionsExecutedSME) * 1000" description="The number of Last-Level Data Cache misses per 1000 SME operations" display="ACCUMULATE" color="246,211,45" units="misses"/>
    </chart>
    <chart title="SME Cache Hit Ratio" series_composition="overlay" rendering_type="line" percentage="yes">
        <series name="L1D" expression="min($L1DataCacheHitSME / $L1DataCacheAccessSME, 1)" description="The percentage of L1 Data Cache accesses that hit in the cache" display="ACCUMULATE" color="51,209,122" units="%"/>
        <series name="L3D" expression="min($L3DataCacheHitSME / $L3DataCacheAccessSME, 1)" description="The percentage of L3 Data Cache accesses that hit in the cache" display="ACCUMULATE" color="53,132,228" units="%"/>
        <series name="LLC" expression="min(($LastLevelCacheAccessSMEDueToRead-$LastLevelCacheMissSMEDueToRead) / $LastLevelCacheAccessSMEDueToRead, 1)" description="The percentage of Last-Level Data Cache accesses that hit in the cache" display="ACCUMULATE" color="145,65,172" units="%"/>
    </chart>
    <chart title="SME Cache Miss Ratio" series_composition="overlay" rendering_type="line" percentage="yes">
        <series name="L1D" expression="min($L1DataCacheRefillSME / $L1DataCacheAccessSME, 1)" description="The percentage of L1 Data Cache accesses that caused a refill" display="ACCUMULATE" color="224,27,36" units="%"/>
        <series name="L3D" expression="min($L3DataCacheRefillSME / $L3DataCacheAccessSME, 1)" description="The percentage of L3 Data Cache accesses that caused a refill" display="ACCUMULATE" color="255,120,0" units="%"/>
        <series name="LLC" expression="min($LastLevelCacheMissSMEDueToRead / $LastLevelCacheAccessSMEDueToRead, 1)" description="The percentage of Last-Level Data Cache accesses that caused a refill" display="ACCUMULATE" color="246,211,45" units="%"/>
    </chart>
    <chart title="SME Refill Source" series_composition="stacked" rendering_type="bar" percentage="yes">
        <series name="L3D" expression="min($L3DataCacheHitSME / $L1DataCacheRefillSME, 1)" description="The percentage of L1 Data Cache refills that hit in the L3 Data Cache" display="ACCUMULATE" color="246,211,45" units="%"/>
        <series name="LLC" expression="min($LastLevelCacheHitSME / $L1DataCacheRefillSME, 1)" description="The percentage of L1 Data Cache refills that hit in the Last-Level Data Cache" display="ACCUMULATE" color="255,120,0" units="%"/>
        <series name="DRAM" expression="min($MemoryAccessToDRAMSME / $L1DataCacheRefillSME, 1)" description="The percentage of L1 Data Cache refills that were fetched from DRAM" display="ACCUMULATE" color="224,27,36" units="%"/>
    </chart>
    <chart title="SME Cache Miss Ratio (Long Latency)" series_composition="stacked" rendering_type="bar" percentage="yes">
        <series name="L1D" expression="min($L1DataCacheMissSMEDueToLongLatencyRead / $L1DataCacheAccessSME, 1)" description="The percentage of L1 Data Cache accesses that caused a refill and incured additional latency" display="ACCUMULATE" color="224,27,36" units="%"/>
        <series name="L3D" expression="min($L3DataCacheMissSMEDueToLongLatencyRead / $L1DataCacheAccessSME, 1)" description="The percentage of L3 Data Cache accesses that caused a refill and incured additional latency" display="ACCUMULATE" color="255,120,0" units="%"/>
    </chart>

    <!-- Misc -->
    <chart title="SME Event Latency" series_composition="overlay" rendering_type="line">
        <series name="Outstanding Loads" expression="$EventLatencyMemorySMERead/$CyclesSMECycles" description="The average number of outstanding SME memory read accesses per SME cycle" display="ACCUMULATE" color="53,132,228" units="accesses"/>
        <series name="Poorly Aligned Loads" expression="$LatencyLoadWithAdditionalLatencyFromAlignmentSME/$CyclesSMECycles" description="The average number of SME memory read accesses per SME cycle that incurred additional latency, due to the alignment of the address and size of data being accessed, which results in load crossing a single cache line" display="ACCUMULATE" color="145,65,172" units="accesses"/>
    </chart>
</template>
